// AndNextStyle.jsx
// This script applies a sequence of Paragraph Style and Next Style
// to selected text. It takes the first Paragraph Style from a
// custom Text Variable called "ParaStyle" set by the user with the
// name of the starting Paragraph Style.
// At each step, the script looks for the "Next Style" value in
// the Paragraph Style it just applied, and applies that to the next
// paragraph in the selection.
//
// This keeps going until all the paragraphs in the selected text
// have been assigned a style.
//
// Code written by Microsoft Copilot from a prompt specifying the above.
//
// Alan Gilbertson
// 20 June 2024
// *****************************************

// Get the selected text
var selectedText = app.selection[0];

// Make sure there is actual text selected.
if (selectedText instanceof Text) {
    // Look for the text variable named "ParaStyle"
    var paraStyleVariable = app.activeDocument.textVariables.itemByName("ParaStyle");
    // Check that ParaStyle exists 
    if (paraStyleVariable.isValid && paraStyleVariable.variableOptions.contents.length > 0) {
        // Get the paragraph style name from the variable content
        var firstStyleName = paraStyleVariable.variableOptions.contents;

        // Find the paragraph style based on the name
        var firstStyle = app.activeDocument.paragraphStyles.itemByName(firstStyleName);

        if (firstStyle.isValid) {
            // Apply the first style to the first paragraph
            selectedText.paragraphs[0].appliedParagraphStyle = firstStyle;

            // Apply subsequent styles based on "Next Style"
            for (var i = 1; i < selectedText.paragraphs.length; i++) {
                var prevStyle = selectedText.paragraphs[i - 1].appliedParagraphStyle;
                var nextStyle = prevStyle.nextStyle;
                if (nextStyle) {
                    selectedText.paragraphs[i].appliedParagraphStyle = nextStyle;
                } else { 
                    // If, for some reason, the specified Next Style doesn't exist or doesn't make sense
                    alert("Error: The paragraph style '" + prevStyle.name + "' does not have a valid 'Next Style'.");
                    break;
                }
            }

            alert("Paragraph styles applied successfully!");
        } else {
            alert("Error: The paragraph style '" + firstStyleName + "' does not exist.");
        }
    } else {
        alert("Error: The 'ParaStyle' text variable is either missing or empty. Please check your document.");
    }
} else {
    alert("Please select a valid text frame or text within a frame.");
}